<?php

namespace App\Http\Controllers\Association;

use App\Enums\AdminLevel;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Country;
use App\Models\EventManager;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;

class EventManagerController extends Controller
{
    public function index(Request $request)
    {
        $eventManagers = Admin::where('association_id', $this->getCurrentUserId())->where('role', AdminLevel::EVENT_MANAGER);
        $eventManagers = $eventManagers->filterEventManager();
        $eventManagers = $eventManagers->paginate(25);
        return view('association.event-manager.index', compact('eventManagers','request'));
    }

    public function create()
    {
        $countryCodes = Country::get();
        return view('association.event-manager.add',compact('countryCodes'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string'],
            'country_code' => ['required'],
            'contact' => ['required'],
            'email' => 'required|unique:admins,email',
            'password' => ['required'],
        ]);
        $data = $request->except(['_token', '_method']);

        $data['password'] =  Hash::make($request->password);
        $data['role'] = AdminLevel::EVENT_MANAGER;
        $data["association_id"] = $this->getCurrentUserId();
        $data['pin'] = $request->password;
        $data['country_code'] = "+" . $data['country_code'];
        Admin::create($data);
        return redirect()->route('events.manager.index')->with('success', 'Event Manager Created Successfully');
    }

    public function edit(Admin $eventManager)
    {
        $countryCodes = Country::get();
        return view('association.event-manager.edit',compact('eventManager', 'countryCodes'));
    }

    public function update(Admin $eventManager, Request $request)
    {
        $request->validate([
            'name' => ['required', 'string'],
            'country_code' => ['required'],
            'contact' => ['required'],
            'email' => [
                'required',
                Rule::unique('admins')->ignore($eventManager->id),
            ],
        ]);
        $data = $request->except(['_token', '_method']);

        $data['pin'] = $data['password'];
        $data['password'] = Hash::make($data['password']);
        $data['country_code'] = "+" . $data['country_code'];
        $eventManager->update($data);
        return redirect()->route('events.manager.index')->with('success', 'Event Manager Updated Successfully');
    }

    public function destroy(Admin $eventManager)
    {
        $eventManager->delete();
        return response()->json(["status" => 200, "message" => "Event Manager Deleted Successfully"]);
    }
}
