<?php

namespace App\Http\Controllers\Association;

use App\Http\Controllers\Controller;
use App\Jobs\SendAssociationNotificationJob;
use App\Models\AssociationNotification;
use Illuminate\Http\Request;

class AssociationNotificationController extends Controller
{
    public function index(Request $request)
    {
        $notifications = AssociationNotification::where('association_id', $this->getCurrentUserId());
        $notifications = $notifications->paginate(25);
        return view('association.notification.index', compact('request', 'notifications'));
    }

    public function create(Request $request)
    {
        return view('association.notification.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'body' => ['required', 'string'],
        ]);
        $associationId = $this->getCurrentUserId();
        $data['association_id'] = $associationId;
        AssociationNotification::create($data);
        SendAssociationNotificationJob::dispatchSync($request->title, $request->body, $associationId);
        return redirect()->route('notifications.index')->with('success', 'Notification Send Successfully');
    }

    public function destroy(AssociationNotification $notification)
    {
        $notification->delete();
        return response()->json(["status" => 200, "message" => "Notification Deleted"]);
    }
}
