<?php

namespace App\Http\Controllers\Admin;

use App\Enums\MetaFileExtensionEnum;
use App\Helpers\MetaClient;
use App\Http\Controllers\Controller;
use App\Jobs\Meta\SendMediaMessage;
use App\Jobs\Meta\SendTextMessage;
use App\Models\Country;
use App\Models\Message;
use App\Models\MessageTemplate;
use App\Models\MetaChatRoom;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class MessageController extends Controller
{
    public function index(Request $request)
    {
        $type = $request->type;
        $metaChatRooms = MetaChatRoom::orderBy('last_updated_at', 'DESC');
        if ($type == "active" || $type == "") {
            $metaChatRooms->where('expire_at', '>=', date("Y-m-d H:i:s:"));
        } else if ($type == "reply_but_expired") {
            $metaChatRooms->where('expire_at', '<=', date("Y-m-d H:i:s:"));
        } else {
            $metaChatRooms = Message::whereNull('meta_chat_room_id')->groupBy('receiver_id')->orderBy('id', 'desc');
        }
        $metaChatRooms = $metaChatRooms->get();

        $countryCodes = Country::get();
        $messageTemplates = MessageTemplate::where('status', MessageTemplate::APPROVED)->select('id', 'name')->get();
        $userId = "";
        if (count($metaChatRooms) > 0) {
            $userId =  $metaChatRooms[0]->user_id;
            if ($type == "no_reply") {
                $userId = $metaChatRooms[0]->receiver_id;
            }
        }
        if ($request->ajax()) {
            $view = view('admin.messages.list', compact('metaChatRooms', 'type'))->render();
            $metaChatRoomsCount = $metaChatRooms->count();
            return [
                "html" => $view,
                "userId" => $userId,
                "metaChatRoomsCount" => $metaChatRoomsCount,
            ];
        }
        return view('admin.messages.index', compact('userId', 'messageTemplates', 'countryCodes'));
    }

    public function details(Request $request)
    {
        $userId = $request->receiverId;
        $metaChatRooms  = MetaChatRoom::where('user_id', $userId)->first();
        if ($metaChatRooms) {
            $metaChatRooms->update([
                "unread_count" => 0
            ]);
        }
        $newMessages = Message::where(function ($q) use ($userId) {
            $q->where('sender_id', $userId)->orWhere('receiver_id', $userId);
        });

        if ($request->type == "check" && $request->latest_message_id) {
            $newMessages->where('id', '>', $request->latest_message_id);
        }
        $messages = $newMessages->get();
        $detailsCheck = $html = $sendMessagehtml = null;
        $messageSendCheck = 0;
        if (!$request->type) {
            $detailsCheck = true;
            $messageSendCheck = 1;
        }
        $userDetails = User::find($userId);
        $messageUserExpireAt = MetaChatRoom::where('user_id', $userId)->first();
        if (isset($messageUserExpireAt) && $messageUserExpireAt->is_expired == false) {
            $messageSendCheck = 1;
        }

        if (($request->message_sent != null) && $request->message_sent == $messageSendCheck) {
            $messageSendCheck = 0;
        } else {
            $messageSendCheck = 1;
        }
        $latestMessage = (count($messages) > 0) ? $newMessages->latest()->first() : null;
        $latestMessageId = null;
        if ($latestMessage) {
            $latestMessageId = $latestMessage->id;
            if ($latestMessage->sender_id != null) {
                MetaClient::api()->markRead($latestMessage->message_id);
            }
        }
        if (count($messages) > 0) {
            $html = view('admin.messages.details', compact('messages', 'userId', 'messageUserExpireAt', 'userDetails', 'detailsCheck', 'latestMessageId'))->render();
        }
        if ($messageSendCheck == 1) {
            $sendMessagehtml = view('admin.messages.send', compact('messageUserExpireAt', 'userDetails'))->render();
        }
        return [
            "html" => $html,
            "latestMessageId" => $latestMessageId,
            "sendMessagehtml" => $sendMessagehtml
        ];
    }

    public function send(Request $request)
    {
        $userId = $request->userId;
        $type = null;
        if ($request->file) {
            $mimeType = $request->file('file')->getMimeType();
            $file = $request->file('file');
            $mediaPath = Storage::put('/whatsapp_media', $file, 'public');
            if (in_array($mimeType, MetaFileExtensionEnum::IMAGE)) {
                $type = MetaFileExtensionEnum::TYPE['image'];
                $body = '<img style="height: 150px;width: 150px;" src="' . asset("storage/" . $mediaPath) . '">';
            } else if (in_array($mimeType, MetaFileExtensionEnum::VIDEO)) {
                $type = MetaFileExtensionEnum::TYPE['video'];
                $body = '<video width="150" height="150" controls><source src="' . asset("storage/" . $mediaPath) . '" type="video/mp4"></video>';
            } else if (in_array($mimeType, MetaFileExtensionEnum::AUDIO)) {
                $type = MetaFileExtensionEnum::TYPE['audio'];
                $body = '<audio controls style="width: 200px;"><source src="' . asset("storage/" . $mediaPath) . '" type="audio/wav"></audio>';
            } else {
                $type = MetaFileExtensionEnum::TYPE['document'];
                $body = "<a href=" . asset("storage/" . $mediaPath) . " download><i class='fa fa-file' aria-hidden='true' style='font-size:21px;margin-right: 10px;'></i>Document</a>";
            }

            $message = Message::create([
                "message" =>  $body,
                "receiver_id" => $userId,
                "message_id" => null,
                "type" => $type,
            ]);
            SendMediaMessage::dispatchSync($request->getHost(), $message->id, $mediaPath);
        } else {
            $message = Message::create([
                "message" =>  $request->message,
                "receiver_id" => $userId,
                "message_id" => null,
            ]);
            SendTextMessage::dispatchSync($request->getHost(), $message->id);
        }
        return [
            "receiverId" => $userId
        ];
    }
}
