<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\SliderResource;
use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    public function index(Request $request)
    {
        try {
            $committees = Slider::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->orderBy('index')->get();
            return $this->sendJson(SliderResource::collection($committees));
        } catch (\Exception $e) {
            $this->logError($e, "Get Sliders Error");
            return $this->sendError($e->getMessage());
        }
    }
}
