<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\NotificationResource;
use App\Models\AssociationNotification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        try {
            $notificationLists = AssociationNotification::where('association_id', $request->attributes->get('association_id'));
            $notificationLists = $notificationLists->simplePaginate(25);
            return NotificationResource::collection($notificationLists);
        } catch (\Exception $e) {
            $this->logError($e, "Notification List Error");
            return $this->sendError($e->getMessage());
        }
    }
}
