<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\MembershipFormResource;
use App\Models\MembershipFormField;
use Illuminate\Http\Request;

class MembershipFormController extends Controller
{
    public function index(Request $request)
    {
        try {
            $membershipFormFields = MembershipFormField::where('association_id', $request->attributes->get('association_id'))
                ->orderBy('index')
                ->get();
            return $this->sendJson(MembershipFormResource::collection($membershipFormFields));
        } catch (\Exception $e) {
            $this->logError($e, "Get Membership-form fields Error");
            return $this->sendError($e->getMessage());
        }
    }
}
