<?php

namespace App\Http\Controllers\API;

use App\Enums\EventPageEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\EventAboutCityResource;
use App\Models\Event;
use App\Models\EventPage;
use Illuminate\Http\Request;

class EventAboutCityController extends Controller
{
    public function index(Request $request)
    {
        try {
            $request->validate([
                'event_id' => ['required'],
            ]);

            $event = Event::find($request->event_id);
            if (!$event) {
                return $this->sendError("Event not found");
            }
            $aboutUs = EventPage::where('event_id', $event->id)->where('type',EventPageEnum::ABOUT_CITY)->get();
            if($aboutUs){
                return $this->sendJson(EventAboutCityResource::collection($aboutUs));
            }
            return $this->sendError("About city details not found");
        } catch (\Exception $e) {
            $this->logError($e, "Event About Us Error");
            return $this->sendError($e->getMessage());
        }
    }
}
