<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventSlabResource;
use App\Models\Event;
use App\Models\EventFormSlab;
use Illuminate\Http\Request;

class EventSlabController extends Controller
{
    public function index(Event $event)
    {
        try {
            $eventSlabs = EventFormSlab::where('event_id', $event->id)->where('status', StatusEnum::ACTIVE)->get();
            return EventSlabResource::collection($eventSlabs);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Workshop Error");
            return $this->sendError($e->getMessage());
        }
    }
}
