<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Models\EventSetting;
use Illuminate\Http\Request;

class EventSettingController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventSettings = EventSetting::where('event_id', $request->attributes->get('event_id'))->get();
            $formattedData = $eventSettings->pluck('value', 'key')->toArray();
            return $this->sendJson([
                'data' => $formattedData
            ]);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Setting Error");
            return $this->sendError($e->getMessage());
        }
    }
}
