<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventImportantLinkResource;
use App\Models\EventImportantLink;
use Illuminate\Http\Request;

class EventImportantLinkController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventImportantLinks = EventImportantLink::where('event_id', $request->attributes->get('event_id'));
            $eventImportantLinks = $eventImportantLinks->simplePaginate(25);
            return EventImportantLinkResource::collection($eventImportantLinks);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Important Link Error");
            return $this->sendError($e->getMessage());
        }
    }
}
