<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventImportantDateResource;
use App\Models\EventImportantDate;
use Illuminate\Http\Request;

class EventImportantDateController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventImportantDates = EventImportantDate::where('event_id', $request->attributes->get('event_id'))
                ->where('status', StatusEnum::ACTIVE);
            $eventImportantDates = $eventImportantDates->simplePaginate(25);
            return EventImportantDateResource::collection($eventImportantDates);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Important Date Error");
            return $this->sendError($e->getMessage());
        }
    }
}
