<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventFormResource;
use App\Models\EventFormCategory;
use App\Models\EventFormInputField;
use Illuminate\Http\Request;

class EventFormController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventFormInputFields = EventFormInputField::where('event_id', $request->attributes->get('event_id'))->get();
            return $this->sendJson(EventFormResource::collection($eventFormInputFields));
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Form Fields Error");
            return $this->sendError($e->getMessage());
        }
    }
}
