<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventEPosterResource;
use App\Models\EventEPoster;
use Illuminate\Http\Request;

class EventEPosterController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventEPosters = EventEPoster::where('event_id', $request->attributes->get('event_id'))
                ->where('status', StatusEnum::ACTIVE);
            $eventEPosters = $eventEPosters->simplePaginate(25);
            return EventEPosterResource::collection($eventEPosters);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Important Date Error");
            return $this->sendError($e->getMessage());
        }
    }
}
