<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventDashboardSponsorResource;
use App\Models\EventDashboardSponsorLink;
use Illuminate\Http\Request;

class EventDashboardSponsorLinkController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventDashboardSponsorLinks = EventDashboardSponsorLink::where('event_id', $request->attributes->get('event_id'));
            $eventDashboardSponsorLinks = $eventDashboardSponsorLinks->simplePaginate(25);
            return EventDashboardSponsorResource::collection($eventDashboardSponsorLinks);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Document List Error");
            return $this->sendError($e->getMessage());
        }
    }
}
