<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventContactUsTypeResource;
use App\Models\EventContactUsType;
use Illuminate\Http\Request;

class EventContactUsController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventId = $request->attributes->get('event_id');
            $eventContactUsType = EventContactUsType::where('event_id', $eventId)->get();
            return EventContactUsTypeResource::collection($eventContactUsType);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Contact Us Type Error");
            return $this->sendError($e->getMessage());
        }
    }
}
