<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventCommitteeMemberResource;
use App\Http\Resources\API\Event\EventCommitteeResource;
use App\Models\EventCommittee;
use App\Models\EventCommitteeMember;
use Illuminate\Http\Request;

class EventCommitteeController extends Controller
{
    public function index(Request $request)
    {
        try {
            $committees = EventCommittee::where('event_id', $request->attributes->get('event_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->get();
            return $this->sendJson(EventCommitteeResource::collection($committees));
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Committee Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function committeeMembers(Request $request, EventCommittee $committee)
    {
        try {
            $committeeMembers = EventCommitteeMember::where('event_id', $request->attributes->get('event_id'))
                ->where('committee_id', $committee->id)
                ->whereHas('member', function ($query) {
                    $query->where('status', StatusEnum::ACTIVE);
                });

                if ($request->filter) {
                    $committeeMembers->whereHas('member',function ($q) use ($request) {
                        $requestContact = preg_replace("/[^0-9]/", "", $request->filter);
                        $q->where('name', 'like', "%{$request->filter}%")
                            ->orWhereLike('contact', $requestContact);
                    });
                }

                $committeeMembers = $committeeMembers->simplePaginate(25);

            return $this->sendJson(EventCommitteeMemberResource::collection($committeeMembers));
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Committee Members Error");
            return $this->sendError($e->getMessage());
        }
    }
}
