<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\ScrollerImageResource;
use Illuminate\Http\Request;

class EventBannerController extends Controller
{
    public function index(Request $request)
    {
        try {
            $event = getEventFromId($request->attributes->get('event_id'));
            $scrollImages = $event->bannerImages()->where('status', StatusEnum::ACTIVE)->simplePaginate(25);
           return ScrollerImageResource::collection($scrollImages);
        } catch (\Exception $e) {
            $this->logError($e, "Get Banners Error");
            return $this->sendError($e->getMessage());
        }
    }
}
