<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventAppSponsorResource;
use App\Models\EventAppSponsorLink;
use Illuminate\Http\Request;

class EventAppSponsorLinkController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventAppSponsorLinks = EventAppSponsorLink::where('event_id', $request->attributes->get('event_id'));
            $eventAppSponsorLinks = $eventAppSponsorLinks->simplePaginate(25);
            return EventAppSponsorResource::collection($eventAppSponsorLinks);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Document List Error");
            return $this->sendError($e->getMessage());
        }
    }
}
