<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventActivityResource;
use App\Models\EventActivity;
use Illuminate\Http\Request;

class EventActivityController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventActivities = EventActivity::where('event_id', $request->attributes->get('event_id'));

            if ($request->filter) {
                $eventActivities->where(function ($q) use ($request) {
                    $q->where('name', 'like', "%{$request->filter}%")
                        ->orWhereLike('title', $request->filter);
                });
            }

            $eventActivities = $eventActivities->simplePaginate(25);
            return EventActivityResource::collection($eventActivities);

        } catch (\Exception $e) {
            $this->logError($e, "Event About Us Error");
            return $this->sendError($e->getMessage());
        }
    }
}
