<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\EventPageEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\EventAboutCityResource;
use App\Models\EventPage;
use Illuminate\Http\Request;

class EventAboutCityController extends Controller
{
    public function index(Request $request)
    {
        try {
            $aboutUs = EventPage::where('event_id', $request->attributes->get('event_id'))->where('type', EventPageEnum::ABOUT_CITY)->first();
            if ($aboutUs) {
                return new EventAboutCityResource($aboutUs);
            }
            return $this->sendError("About city details not found");
        } catch (\Exception $e) {
            $this->logError($e, "Event About City Error");
            return $this->sendError($e->getMessage());
        }
    }
}
