<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventDayResource;
use App\Models\EventDay;
use Illuminate\Http\Request;

class DaysController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventDays = EventDay::where('event_id', $request->attributes->get('event_id'));

            if ($request->name) {
                $eventDays->where(function ($q) use ($request) {
                    $q->where('name', 'like', "%{$request->name}%");
                });
            }

            $eventDays = $eventDays->simplePaginate(25);
            $request->merge(['display_event_venues_details' => true]);
            return EventDayResource::collection($eventDays);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Day Error");
            return $this->sendError($e->getMessage());
        }
    }
}
