<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\CommitteeMemberResource;
use App\Http\Resources\API\CommitteeResource;
use App\Models\Committee;
use App\Models\CommitteeMember;
use Illuminate\Http\Request;

class CommitteeController extends Controller
{
    public function index(Request $request)
    {
        try {
            $committees = Committee::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->latest()->get();
            return $this->sendJson(CommitteeResource::collection($committees));
        } catch (\Exception $e) {
            $this->logError($e, "Get Committee Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function committeeMembers(Request $request, Committee $committee)
    {
        try {
            $committeeMembers = CommitteeMember::where('association_id', $request->attributes->get('association_id'))
                ->where('commity_id', $committee->id)
                ->whereHas('member', function ($query) {
                    $query->where('status', StatusEnum::ACTIVE);
                })
                ->orderBy('index')->get();

            return $this->sendJson(CommitteeMemberResource::collection($committeeMembers));
        } catch (\Exception $e) {
            $this->logError($e, "Get Committee Members Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function standingMembers(Request $request)
    {
        try {
            $committee = Committee::where('name', 'Standing')->where('association_id', $request->attributes->get('association_id'))->first();
            if (!$committee) {
                return $this->sendError("Committee not found");
            }
            $committeeMembers = CommitteeMember::where('association_id', $request->attributes->get('association_id'))
                ->where('commity_id', $committee->id)
                ->whereHas('member', function ($query) {
                    $query->where('status', StatusEnum::ACTIVE);
                })
                ->orderBy('index')->get();

            return $this->sendJson(CommitteeMemberResource::collection($committeeMembers));
        } catch (\Exception $e) {
            $this->logError($e, "Standing Committee Members Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function executiveMembers(Request $request)
    {
        try {
            $committee = Committee::where('name', 'Executive')->where('association_id', $request->attributes->get('association_id'))->first();
            if (!$committee) {
                return $this->sendError("Committee not found");
            }
            $committeeMembers = CommitteeMember::where('association_id', $request->attributes->get('association_id'))
                ->where('commity_id', $committee->id)
                ->whereHas('member', function ($query) {
                    $query->where('status', StatusEnum::ACTIVE);
                })
                ->orderBy('index')->get();

            return $this->sendJson(CommitteeMemberResource::collection($committeeMembers));
        } catch (\Exception $e) {
            $this->logError($e, "Executive Committee Members Error");
            return $this->sendError($e->getMessage());
        }
    }
}
