<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\BannerResource;
use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    public function index(Request $request)
    {
        try {
            $banners = Banner::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->orderBy('index')->get();
            return $this->sendJson(BannerResource::collection($banners));
        } catch (\Exception $e) {
            $this->logError($e, "Get Banners Error");
            return $this->sendError($e->getMessage());
        }
    }
}
