<?php

namespace App\Helpers;

use App\Models\Notification as ModelsNotification;
use App\Models\UserFcmToken;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\Notification;
use Kreait\Firebase\Messaging\CloudMessage;

class SendNotification
{
    protected $title;
    protected $body;
    protected array $tokens = [];
    protected array $userIds;

    public function __construct($title, $body)
    {
        $this->title = $title;
        $this->body = $body;
    }

    // public function setUserIds(array $userIds)
    // {
    //     $tokens = UserFcmToken::whereIn('user_id', $userIds)->distinct()->pluck('token')->toArray();
    //     $this->tokens = $tokens;
    // }

    // public function setAllUserToken()
    // {
    //     $tokens = UserFcmToken::whereNotNull('user_id')->distinct()->pluck('token')->toArray();
    //     $this->tokens = $tokens;
    // }

    // public function cleanseArray(array $data)
    // {
    //     return array_filter($data, function ($value) {
    //         if (is_array($value)) {
    //             return !empty(array_filter($value, fn($v) => !is_null($v)));
    //         }
    //         return !is_null($value);
    //     });
    // }

    public function send()
    {
        try {
            $tokens = UserFcmToken::all()->pluck('token')->toArray();
            $tokens = "fgYInAMGTD6fzMlknm80gy:APA91bEKOp3Q_ToKxvZALs-uBEUOclm5WPX1L8c4q1CFEv-FY3lgvd0UzF52uWU0tSjiAeRTkhHMpqfA15KehT8o4rUCOOnam4QZV0rekRMb_9MVy1wEw1g";
            Log::info("Send notification Starts");

            if (!file_exists(storage_path('credentials/firebase-credentials.json'))) {
                Log::error("Firebase credentials file not found");
                return false;
            }

            $factory = (new Factory())->withServiceAccount(storage_path('credentials/firebase-credentials.json'));
            $messaging = $factory->createMessaging();

            $notification = Notification::create(
                $this->title,
                $this->body
            );
            $message = CloudMessage::new()->withNotification($notification);

            $messaging->sendMulticast($message, $tokens);
            Log::info("Send notification End");
            return true;
        } catch (\Exception $e) {
            Log::error("Send Notification Error: " . $e->getMessage());
            return false;
        }
    }
}
