<?php

use App\Enums\EventManagerEnum;
use App\Enums\EventSettingEnum;
use App\Enums\MailTemplateCampaignEnum;
use App\Enums\RoleEnum;
use App\Enums\StatusEnum;
use App\Enums\TitleEnum;
use App\Models\Admin;
use App\Models\AssociationUser;
use App\Models\Country;
use App\Models\Event;
use App\Models\EventManager;
use App\Models\EventSetting;
use App\Models\MessageTemplate;
use App\Models\User;
use App\Rules\DisposableEmailRule;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;

function getFilePath($path, $host = null)
{
    return asset('storage/' . $path);
}

function checkFileExist($path, $host = null)
{
    if ($path == null) {
        return false;
    }
    return Storage::exists($path);
}

function messageTemplateQuery()
{
    return MessageTemplate::where('status', MessageTemplate::APPROVED)->select('id', 'name')->get()->toArray();
}

function whatsappLink($mobile)
{
    return 'https://wa.me/+91' . $mobile;
}

function exportToCsv(Request $request, $data, $filename, $columns, $callback)
{
    // Handle callable data source
    $data = is_callable($data) ? $data() : $data;

    $headers = [
        "Content-type" => "text/csv",
        "Content-Disposition" => "attachment; filename=$filename",
        "Pragma" => "no-cache",
        "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
        "Expires" => "0"
    ];

    $callback = function () use ($data, $columns, $callback) {
        $file = fopen('php://output', 'w');
        fputcsv($file, $columns);
        $i = 1;
        foreach ($data as $item) {
            $row = $callback($item, $i);
            fputcsv($file, $row);
            $i++;
        }
        fclose($file);
    };

    return response()->stream($callback, 200, $headers);
}


function getMailjetTemplates()
{
    // $apiKey = config('mail.mailers.mailjet.key');
    // $apiSecret = config('mail.mailers.mailjet.secret');
    $apiKey = '35bae179638bd4e81c47a0c1687bc4f8';
    $apiSecret = 'b46bef046f4d8ece9728db1e5c6a251d';
    $response = Http::withBasicAuth($apiKey, $apiSecret)
        ->get('https://api.mailjet.com/v3/REST/template?limit=1000');
    return $response['Data'] ?? [];
}

function cleanseArray(array $data)
{
    return array_filter($data, function ($value) {
        if (is_array($value)) {
            return !empty(array_filter($value, fn($v) => !is_null($v)));
        }
        return !is_null($value);
    });
}

function getFormattedDates($date, $format = 'd-m-Y')
{
    return Carbon::parse($date)->format($format);
}

if (!function_exists('getTimezoneDateTime')) {
    function getTimezoneDateTime($date, $format = 'd-m-Y | h:i A')
    {
        return Carbon::parse($date)->timezone('Asia/Kolkata')->format($format);
    }
}

if (!function_exists('getCountries')) {
    function getCountries()
    {
        return Country::orderBy('name')->get();
    }
}

if (!function_exists('getEventFromId')) {
    function getEventFromId($id)
    {
        return Event::find($id);
    }
}

if (!function_exists('getEventFromCode')) {
    function getEventFromCode($code)
    {
        return Event::where('code', $code)->first();
    }
}

if (!function_exists('getAssociationFromCode')) {
    function getAssociationFromCode($code)
    {
        return User::where('association_code', $code)
            ->where('role', RoleEnum::ASSOCIATION)->first();
    }
}

if (!function_exists('getAssociationFromId')) {
    function getAssociationFromId($id)
    {
        return User::where('id', $id)
            ->where('role', RoleEnum::ASSOCIATION)->first();
    }
}

if (!function_exists('isAssociationUser')) {
    function isAssociationUser(User $user, $id): bool
    {
        return AssociationUser::where('user_id', $user->id)
            ->where('association_id', $id)->exists();
    }
}

if (!function_exists('setEnvironmentVariable')) {
    function setEnvironmentVariable($key, $value, $eventId)
    {
        EventSetting::updateOrCreate([
            "event_id" => $eventId,
            "key" => $key,
        ], [
            "value" => $value,
        ]);
        return null;
    }
}

if (!function_exists('getEnvironmentVariable')) {
    function getEnvironmentVariable($key, $eventId)
    {
        $eventSetting = EventSetting::where('event_id', $eventId)->where('key', $key)->first();
        if ($eventSetting) {
            return $eventSetting->value;
        }
        return null;
    }
}

if (!function_exists('getEventSettingVariables')) {
    function getEventSettingVariables()
    {
        return EventSettingEnum::VARIABLES;
    }
}

if (!function_exists('getBasicFields')) {
    function getBasicFields()
    {
        $basicFields = [
            "full_name",
            "email",
            "mobile",
            "country",
            "state",
            "city"
        ];
        return $basicFields;
    }
}

if (!function_exists('removeDisposableEmails')) {
    function removeDisposableEmails(array $emailArray): array
    {
        $disposableEmailRule = new DisposableEmailRule();
        $cleanedEmails = [];
        foreach ($emailArray as $email) {
            if (!$disposableEmailRule->isDisposable($email)) {
                $cleanedEmails[] = $email; // Add to cleaned array if not disposable
            }
        }
        return $cleanedEmails;
    }
}

if (!function_exists('checkEventManagerPrivileges')) {
    function checkEventManagerPrivileges(): bool
    {
        if (Auth::guard('admin')->check()) {
            $admin = auth()->guard('admin')->user();
            return $admin->permission_level == EventManagerEnum::EDIT;
        }
        return true;
    }
}

function getAssociationUser(User $user, User $association)
{
    return $user->associationUsers()->where('association_id', $association->id)->first();
}
