<?php declare(strict_types=1);

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
 * @method static static OptionOne()
 * @method static static OptionTwo()
 * @method static static OptionThree()
 */
final class MetaFileExtensionEnum extends Enum
{
    const AUDIO = [
        "audio/aac",
        "audio/mp4",
        "audio/mpeg",
        "audio/amr",
        "audio/ogg; codecs=opus",
    ];

    const VIDEO = [
        "video/mp4",
        "video/3gp",
    ];

    const IMAGE = [
        "image/jpeg",
        "image/png",
        "image/webp",
    ];

    const DOCUMENT = [
        "text/plain",
        "application/pdf",
        "application/vnd.ms-powerpoint",
        "application/msword",
        "application/vnd.ms-excel",
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    ];

    const TYPE = [
        "text" => 1,
        "image" => 2,
        "video" => 3,
        "document" => 4,
        "sticker" => 5
    ];
}
