<?php declare(strict_types=1);

namespace App\Enums;

use BenSampo\Enum\Enum;

final class EventSessionEnum extends Enum
{
    //STATUS
    const UPCOMING_STATUS = 1;
    const ONGOING_STATUS = 2;
    const COMPLETED_STATUS = 3;

    public static function getStatusAndColors(): array
    {
        return [
            self::UPCOMING_STATUS => '#f1b44c',
            self::ONGOING_STATUS => '#50a5f1',
            self::COMPLETED_STATUS => '#dc3545',
        ];
    }

    public static function getStatusLabels(): array
    {
        return [
            self::UPCOMING_STATUS => 'Upcoming',
            self::ONGOING_STATUS => 'Ongoing',
            self::COMPLETED_STATUS => 'Completed',
        ];
    }
}
