<?php declare(strict_types=1);

namespace App\Enums;

use BenSampo\Enum\Enum;

final class EventManagerEnum extends Enum
{
    public const VIEW = 1;
    public const EDIT = 2;


    public static function getPrivileges(): array
    {
        return [
            'View Only' => self::VIEW,
            'Full Edit' => self::EDIT,
        ];
    }

    public function label(): string
    {
        return match ($this) {
            self::VIEW => 'View Only',
            self::EDIT => 'Full Edit',
        };
    }
}
