<?php

namespace App\Console\Commands;

use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Illuminate\Console\Command;

class AddStateAndCityDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:add-state-city-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ini_set('memory_limit', '512M');
        //Add/Update States
        $statesData = json_decode(file_get_contents(storage_path("country/state.json")), true);

        foreach ($statesData as $stateData) {
            $countryName = $stateData['country_name'];

            $country = Country::where('name', $countryName)->first();

                if ($country) {
                    State::updateOrCreate(
                        [
                            "name" => $stateData["name"],
                            'country_id' => $country->id,
                            "status" => 1  //active,
                        ],
                        [
                            "name" => $stateData["name"],
                        ]
                );
            }
            // $this->info("Sates '{$stateData["name"]}' in Country : '{$countryName}' updated/created successfully.");
        }

        $this->info('States data updated successfully.');

        //Add/Update Cities
        $citiesData = json_decode(file_get_contents(storage_path("country/city.json")), true);

        foreach ($citiesData as $cityData) {
            $stateName = $cityData['state_name'];
            $countryName = $cityData['country_name'];

            // Find the country
            $country = Country::where('name', $countryName)->first();
            // Find the state
            $state = State::where('name', $stateName)->first();

            if ($country && $state) {

                    City::updateOrCreate(
                        [
                            'country_id' => $country->id,
                            'state_id' => $state->id,
                            "name" => $cityData["name"],
                            "status" => 1 //active,
                        ],
                        [
                            "name" => $cityData["name"],
                        ]
                    );

                //  $this->info("City '{$cityData["name"]}' in Country : '{$countryName}' and State : {$countryName} updated/created successfully.");
            }
        }

        $this->info('Cities data updated successfully.');

        return 0;
    }
}
